package cn.com.duiba.oto.dto.oto.board.invite;

import lombok.Data;

import java.io.Serializable;

/**
 * 邀约明细数据对象
 */
@Data
public class OtoInviteSubSummaryDto implements Serializable {
    private static final long serialVersionUID = 4011617160188918337L;

    /**
     * 客户总数（人）
     */
    private Integer allCustCount = 0;

    /**
     * 未联系客户数（10天）
     */
    private Integer unContact10dayCustCount = 0;

    /**
     * 未联系客户数（20天）
     */
    private Integer unContact20dayCustCount = 0;

    /**
     * 昨日呼出客户数
     */
    private Integer yesterdayCallOutCustCount = 0;

    /**
     * 本周呼出客户数
     */
    private Integer weekCallOutCustCount = 0;

    /**
     * 本月呼出客户数
     */
    private Integer monthCallOutCustCount = 0;

    /**
     * 昨日接通客户数
     */
    private Integer yesterdayCallConnectCustCount = 0;

    /**
     * 本周接通客户数
     */
    private Integer weekCallConnectCustCount = 0;

    /**
     * 本月接通客户数
     */
    private Integer monthCallConnectCustCount = 0;

    /**
     * 昨日接通时长
     */
    private Integer yesterdayCallConnectTime = 0;

    /**
     * 本周接通时长
     */
    private Integer weekCallConnectTime = 0;

    /**
     * 本月接通时长
     */
    private Integer monthCallConnectTime = 0;

    /**
     * 昨日平均接通时长
     */
    private Integer yesterdayCallConnectTimeAvg = 0;

    /**
     * 本周平均接通时长
     */
    private Integer weekCallConnectTimeAvg = 0;

    /**
     * 本月平均接通时长
     */
    private Integer monthCallConnectTimeAvg = 0;

    /**
     * 昨日应邀客户数
     */
    private Integer yesterdayInviteCustCount = 0;

    /**
     * 本周应邀客户数
     */
    private Integer weekInviteCustCount = 0;

    /**
     * 本月应邀客户数
     */
    private Integer monthInviteCustCount = 0;

    /**
     * 昨日到场客户数
     */
    private Integer yesterdayMeetCustCount = 0;

    /**
     * 本周到场客户数
     */
    private Integer weekMeetCustCount = 0;

    /**
     * 本月到场客户数
     */
    private Integer monthMeetCustCount = 0;

    /**
     * 新客户总数
     */
    private Integer newCustCount = 0;

    /**
     * 新客户联系客户数
     */
    private Integer newCustContactCustCount = 0;

    /**
     * 新客户接通客户数
     */
    private Integer newCustCallConnectCustCount = 0;

    /**
     * 新客户应邀客户数
     */
    private Integer newCustInviteCustCount = 0;

    /**
     * 新客户到场客户数
     */
    private Integer newCustMeetCustCount = 0;

    /**
     * 新客户鸽子客户数
     */
    private Integer newCustDoveCustCount = 0;

    /**
     * 新客户无效客户数
     */
    private Integer newCustInvalidCustCount = 0;

    /**
     * 新客户明确拒绝客户数
     */
    private Integer newCustRejectCustCount = 0;

    /**
     * 老客户总数
     */
    private Integer oldCustCount = 0;

    /**
     * 老客户联系客户数
     */
    private Integer oldCustContactCustCount = 0;

    /**
     * 老客户接通客户数
     */
    private Integer oldCustCallConnectCustCount = 0;

    /**
     * 老客户应邀客户数
     */
    private Integer oldCustInviteCustCount = 0;

    /**
     * 老客户到场客户数
     */
    private Integer oldCustMeetCustCount = 0;

    /**
     * 老客户鸽子客户数
     */
    private Integer oldCustDoveCustCount = 0;

    /**
     * 老客户无效客户数
     */
    private Integer oldCustInvalidCustCount = 0;

    /**
     * 老客户明确拒绝客户数
     */
    private Integer oldCustRejectCustCount = 0;

}
