package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.custAssign.param.CustAssignBaseBean;
import cn.com.duiba.oto.dto.oto.cust.custAssign.result.CustAssignResultBean;
import cn.com.duiba.oto.dto.oto.cust.custImport.param.CustImportBaseBean;
import cn.com.duiba.oto.dto.oto.cust.custImport.result.CustImportResultBean;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 17:16
 */
@AdvancedFeignClient
public interface RemoteCustLifeCycleService {

    /**
     * 导入客户
     *
     * @param bean 客户信息
     * @param <T>  客户信息泛型
     * @return 导入客户结果
     */
    <T extends CustImportBaseBean> CustImportResultBean<T> importCust(T bean);

    /**
     * 校验分配权限
     * @param bean 分配客户
     * @return 分配结果
     */
    <T extends CustAssignBaseBean> CustAssignResultBean<T> checkAssignPermission(T bean);

    /**
     * 分配客户
     * @param bean 分配客户
     * @return 分配结果
     */
    <T extends CustAssignBaseBean> CustAssignResultBean<T> assignCust(T bean);

    /**
     * 批量分配客户(因为需要分组操作，所以返回结果非顺序)
     * @param beanList 分配客户
     * @return 分配结果
     */
    <T extends CustAssignBaseBean> List<CustAssignResultBean<T>> batchAssignCust(List<T> beanList);
}