package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 权益配置表
 * @author kjj mybatis generator 
 * @date 2023-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoEquityConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16869020175265946L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 权益名称
     */
    private String equityName;

    /**
     * 权益图片
     */
    private String equityUrl;

    /**
     * 可用等级
     */
    private String equityLevel;

    /**
     * 是否开启 0否 1是
     */
    private Integer equityStatus;

    /**
     * 权益类型：1：健康体检、2：健康养护、3：就医协助、4：健康保障、5：乐享生活、6：文旅出行
     */
    private Integer equityType;

    /**
     * 兑换积分
     */
    private Long creditsExchange;

    /**
     * 权益说明
     */
    private String equityDescription;

    /**
     * 权益须知
     */
    private String equityNotice;

    /**
     * 权益图片
     */
    private String detailUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}