package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.OtoCustEquityDto;
import cn.com.duiba.oto.dto.oto.cust.equity.CustEquityDto;
import cn.com.duiba.oto.dto.oto.cust.equity.IntegralRecordDto;
import cn.com.duiba.oto.param.oto.cust.OtoEquityConfSearchParam;
import cn.com.duiba.oto.param.oto.cust.equity.ModifyEquityParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-16 10:00
 */
@AdvancedFeignClient
public interface RemoteCustEquityService {

    /**
     * 新增权益
     */
    boolean save(OtoEquityConfSearchParam param);

    /**
     * 修改权益
     */
    boolean update(OtoEquityConfSearchParam param);

    /**
     * 查询所有权益
     */
    List<OtoCustEquityDto> list();

    /**
     * 查询权益详情
     */
    OtoCustEquityDto detail(Long id);

    /**
     * 批量查询权益详情
     */
    List<OtoCustEquityDto> detailByIds(List<Long> ids);

    /**
     * 新增or编辑客户权益（兑换/管理后台添加）
     * @param custEquityDto
     * @return
     */
    boolean saveCustEquity(CustEquityDto custEquityDto);

    /**
     * 删除客户权益
     * @param id 客户权益关系id
     * @return
     */
    boolean deleteCustEquity(Long id);

    /**
     * 根据客户id获取客户所有的权益列表
     * @param custId
     * @return
     */
    List<CustEquityDto> selectEquityByCustId(Long custId);

    /**
     * 新增客户积分记录（兑换权益/管理后台编辑积分数量）
     * @param integralRecord
     * @return
     */
    boolean saveIntegralRecord(IntegralRecordDto integralRecord);

    /**
     * 根据客户id获取客户所有的积分记录列表
     * @param custId
     * @return
     */
    List<IntegralRecordDto> selectIntegralRecordByCustId(Long custId);

    /**
     * 积分兑换权益
     * @param custId
     * @param equityId
     * @return
     */
    boolean changeEquity(Long custId,Long equityId) throws BizException;


    /**
     * 修改客会员权益相关(v2)
     */
    Boolean modifyCustEquityV2(ModifyEquityParam param) throws BizException;
}
