package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.form.CustFormDetailDto;
import cn.com.duiba.oto.dto.oto.cust.form.OtoCustFormDto;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormDetailParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormOrderParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSaveDetailParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSaveParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormStatusParam;
import cn.com.duiba.oto.param.oto.cust.form.RemoteCustFormSubmitParam;

import java.util.List;


/**
 * 客户资料表单
 *
 * @author xiaotian
 */

@AdvancedFeignClient
public interface RemoteOtoCustFormQuestionService {

    /**
     * 新增表单
     *
     * @param remoteCustFormSaveParam
     * @return
     */
    boolean saveForm(RemoteCustFormSaveParam remoteCustFormSaveParam) throws BizException;

    /**
     * 表单状态
     *
     * @param remoteCustFormStatusParam
     * @return
     */
    boolean formStatus(RemoteCustFormStatusParam remoteCustFormStatusParam);

    /**
     * 表单移动
     *
     * @param remoteCustFormOrderParam
     * @return
     */
    boolean order(RemoteCustFormOrderParam remoteCustFormOrderParam);

    /**
     * 获取所有表单
     *
     * @return
     */
    List<OtoCustFormDto> getAllForm();

    /**
     * 获取所有开启的表单
     *
     * @return
     */
    List<OtoCustFormDto> getAllOpenedForm();

    /**
     * 新增编辑表单详情
     *
     * @param remoteCustFormSaveDetailParam
     * @return
     */
    boolean saveFormQuestion(RemoteCustFormSaveDetailParam remoteCustFormSaveDetailParam) throws BizException;

    /**
     * 提交客户表单
     *
     * @param remoteCustFormSaveDetailParam
     * @return
     */
    boolean submitFormQuestion(RemoteCustFormSubmitParam remoteCustFormSaveDetailParam);


    /**
     * 获取表单详情
     *
     * @param remoteCustFormDetailParam
     * @return
     */
    List<CustFormDetailDto> getFromDetailDto(RemoteCustFormDetailParam remoteCustFormDetailParam);


}
