package cn.com.duiba.oto.param.oto.cust.equity;

import com.google.common.collect.Lists;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author liuyj
 * @date 2023/6/16 13:40
 */
@Data
public class ModifyEquityParam implements Serializable {

    private static final long serialVersionUID = -8596108566210053191L;
    /**
     * 客户ID
     */
    @NotNull(message = "客户ID不能为空")
    private Long custId;

    /**
     * 等级
     */
    @NotNull(message = "等级不能为空")
    private Integer level;

    /**
     * 积分
     */
    @NotNull(message = "积分不能为空")
    private Integer integral;

    /**
     * 积分变动原因 1：首次配置 2：加保 3：退保 4：取消权益
     */
    private Integer reason;

    /**
     * 权益ID集合
     */
    private List<EquityParam> equityParams = Lists.newArrayList();

    @Data
    public static class EquityParam implements Serializable{
        private static final long serialVersionUID = -2611484509120499216L;
        /**
         * 权益ID
         */
        private Long id;

        /**
         * 领取状态 1：已领取 0：未领取
         */
        private Integer conversionStatus;
    }

}
