package cn.com.duiba.oto.enums.cust.equity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 权益类型枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum EquityTypeEnum {

    PHYSICAL(1, "健康体检"),
    CONSERVE(2, "健康养护"),
    ASSIST(3, "就医协助"),
    SAFEGUARD(4, "健康保障"),
    LIVE(5, "乐享生活"),
    TRIP(6, "文旅出行"),
    ;

    private static final Map<Integer, EquityTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(EquityTypeEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    EquityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EquityTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
