package cn.com.duiba.oto.enums.cust.equity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 权益类型枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum IntegralTypeEnum {

    EXCHANGE(0, "兑换商品"),
    FRIST(1, "首次存款"),
    ADD(2, "增加存款"),
    REDUCE(3, "减少存款"),
    CANCEL(4, "取消权益"),
    ;

    private static final Map<Integer, IntegralTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(IntegralTypeEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    IntegralTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static IntegralTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
