package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * OTO-分配角色类型
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum CustLevelTypeEnum {

    NORMAL(1, "普卡"),
    SILVER(2, "银卡"),
    METALS(3, "金卡"),
    PLATINUM(4, "铂金卡"),
    DIAMOND(5, "钻石卡"),
    BLACK_DIAMOND(6, "黑钻卡")
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustLevelTypeEnum::getCode, CustLevelTypeEnum::getDesc, (v1, v2)->v1)));


    public static String getDescByCode(Integer code){
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static CustLevelTypeEnum getByCode(Integer code){
        if (code == null) {
            return null;
        }
        return Stream.of(CustLevelTypeEnum.values()).filter(assignRoleTypeEnum -> assignRoleTypeEnum.getCode().equals(code)).findFirst().orElse(null);
    }
}
