package cn.com.duiba.oto.enums.oa;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * OTO-oa审批状态
 * @author liuyj
 */
@Getter
@AllArgsConstructor
public enum OaAuditStatusEnum {

    WAIT_AUDIT(1, "待审批"),
    AUDIT_SUCCESS(2, "已通过"),
    AUDIT_REFUSED(3, "已驳回"),
    UPLOAD_PLAN(4, "已上传方案")
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OaAuditStatusEnum::getCode, OaAuditStatusEnum::getDesc, (v1, v2)->v1)));


    public static String getDescByCode(Integer code){
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
