package cn.com.duiba.oto.oto.service.api.remoteservice.fission;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.fission.FissionCustDto;
import cn.com.duiba.oto.dto.oto.fission.IndexDto;
import cn.com.duiba.oto.param.oto.fission.RemoteAppointmentParam;
import cn.com.duiba.oto.param.oto.fission.RemoteCustSaveParam;
import cn.com.duiba.oto.param.oto.fission.RemoteSearchCustParam;
import cn.com.duiba.oto.param.oto.fission.RemoteVerifyParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * @author xiaotian
 * @date 2024/02/18
 */
@AdvancedFeignClient
public interface RemoteFissionService {

    /**
     * 客户列表
     */
    PageResult<FissionCustDto> custList(RemoteSearchCustParam param);


    /**
     * 预约领奖时间
     */
    Boolean appointment(RemoteAppointmentParam param);


    /**
     * 核销
     */
    Boolean batchVerify(RemoteVerifyParam param);


    /**
     * 客户入库
     */
    Boolean saveCust(RemoteCustSaveParam param) throws BizException;


    /**
     * 客户进入活动首页
     *
     * @return 客户信息
     */
    IndexDto index(Long fromUserId, Long userId, String ip);

    /**
     * 参与抽奖
     *
     * @return 奖品id
     */
    Long join(Long fromUserId, Long userId, String ip) throws BizException;
}
