package cn.com.duiba.oto.param.oto.pay.request.wxpay;

import cn.com.duiba.oto.param.oto.pay.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 微信小程序支付请求
 *
 * @author xiaotian
 * @date 2020/2/28 12:03 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayLiteChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = -1889807126990946401L;

    /**
     * 订单标题
     * 会传给第三方支付
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;

    /**
     * 客户端ip地址
     * 获取用户真实ip
     *
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5_sl.php?chapter=15_5
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String clientIp;

    /**
     * 用户的微信openid
     */
    @Size(max = 128, message = "用户的微信openid长度超过128")
    private String openId;
}
