package cn.com.duiba.oto.param.oto.rights;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiaotian
 * @date 2023/9/06 13:40
 */
@Data
public class RightsPackageSaveParam implements Serializable {

    private static final long serialVersionUID = 3193593951825557079L;

    private Long id;
    /**
     * 权益包名称
     */
    private String packageName;
    /**
     * 产品有效期（天）
     */
    private Integer expiryDate;
    /**
     * 产品原始价格
     */
    private Integer originalPrice;
    /**
     * 产品优惠价格
     */
    private Integer preferentialPrice;
    /**
     * 启用状态: 1:启用 0:禁用
     */
    private Integer packageState;
    /**
     * 绑定的权益列表
     */
    private List<RightsParam> rightsParams;


    @Data
    public static class RightsParam implements Serializable {

        private static final long serialVersionUID = -307334596003117990L;

        /**
         * 权益id
         */
        private Long rightId;

        /**
         * 次数
         */
        private Integer times;
        /**
         * 天数
         */
        private Integer days;

        /**
         * 百分比
         */
        private Integer percent;
    }

}