package cn.com.duiba.oto.param.oto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author huliangsheng
 * @Date 2024/8/13 15:09
 */
@Data
public class RemoteSaveOrUpdateGoodsParam implements Serializable {

    private static final long serialVersionUID = 1873297733997784319L;
    /**
     * 商品id
     */
    private Long id;
    /**
     * 商品标题
     */
    private String goodsTitle;
    /**
     * 商品图片
     */
    private String goodsImage;
    /**
     * 商品详情图片
     */
    private String goodsDetailImages;
    /**
     * 商品描述
     */
    private String goodsDesc;
    /**
     * 商品有效期
     */
    private Date validPeriod;
    /**
     * 原价
     */
    private Integer originalPrice;
    /**
     * 优惠价
     */
    private Integer favourPrice;
    /**
     * 库存
     */
    private Integer goodsStocks;
    /**
     * 限购数
     */
    private Integer limitBuyCount;
    /**
     * 商品状态 0-保存 1-上架
     */
    private Integer saleStatus;
    /**
     * 剩余库存数
     */
    private Integer remainStocks;
    /**
     * 上架时间
     */
    private Date saleTime;
    /**
     * 商品规格
     */
    private String goodsStandard;
}


