/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.ext;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OtoCustMoneyEnum {
    UN_KNOW(0, "\u4e0d\u8be6"),
    NO_MONEY(1, "\u65e0\u8d44\u91d1"),
    HAS_MONEY(2, "\u8d44\u91d1\u5df2\u5230\u4f4d"),
    LATER_HAS_MONEY(3, "\u8d44\u91d1\u8fd1\u671f\u5230\u4f4d"),
    NEXT_YEAR_HAS_MONEY(4, "\u8d44\u91d1\u660e\u5e74\u5230\u4f4d");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, String> ALL_MAP;

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }

    public static boolean hasPayPower(Integer hasMoney) {
        return HAS_MONEY.getType().equals(hasMoney) || LATER_HAS_MONEY.getType().equals(hasMoney);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustMoneyEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ALL_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustMoneyEnum.values()).collect(Collectors.toMap(OtoCustMoneyEnum::getType, OtoCustMoneyEnum::getDesc, (v1, v2) -> v1)));
    }
}

