package cn.com.duiba.oto.dto.oto.goods.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/14 15:46
 */
@Data
public class OrderDto implements Serializable {

    private static final long serialVersionUID = 1220085817764510885L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 下单商品数量
     */
    private Integer orderStocks;

    /**
     * 实际扣减库存数量
     */
    private Integer actualStocks;

    /**
     * 订单状态：0:待支付 1:已支付 2:已完成 3:已退款
     */
    private Integer orderStatus;

    /**
     * 支付订单编号
     */
    private String paymentNo;

    /**
     * tb_oto_wx_user.id 微信账户id
     */
    private Long userId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 购买的商品规格
     */
    private String goodsStandard;

    /**
     * 购买数量
     */
    private Integer purchaseCount;

    /**
     * 原价
     */
    private Integer originalPrice;

    /**
     * 实付价格
     */
    private Integer paymentPrice;

    /**
     * 立减金
     */
    private Integer minusPrice;

    /**
     * 核销时间
     */
    private Date verifyTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


}
