package cn.com.duiba.oto.oto.service.api.remoteservice.goods.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.goods.order.OrderDetail;
import cn.com.duiba.oto.dto.oto.goods.order.OrderListVO;
import cn.com.duiba.oto.param.oto.goods.RemoteGenerateOrderParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteSearchOrderParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * @Description 订单接口
 * @Author huliangsheng
 * @Date 2024/8/14 15:45
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 订单列表
     */
    PageResult<OrderListVO> list(RemoteSearchOrderParam param);

    /**
     * 订单详情
     */
    OrderDetail detail(Long id);

    /**
     * 核销
     */
    Boolean verify(Long id);

    /**
     * 退款
     */
    Boolean refund(Long id);

    /**
     * 生成商品订单
     */
    Boolean generateOrder(RemoteGenerateOrderParam param);

}
