package cn.com.duiba.oto.dto.oto.goods.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/14 20:37
 */
@Data
public class OrderDetail implements Serializable {
    private static final long serialVersionUID = 1220085817764510885L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 商品图片（展示图）
     */
    private String goodsImage;

    /**
     * 购买的商品规格
     */
    private String goodsStandard;

    /**
     * 下单商品数量
     */
    private Integer orderStocks;

    /**
     * 订单原价
     */
    private Integer orderPrice;
    /**
     * 实付价格
     */
    private Integer paymentPrice;

    /**
     * 立减金
     */
    private Integer coupons;
    /**
     * 用户姓名
     */
    private String custName;
    /**
     * 客户id
     */
    private Long custId;
    /**
     * 下单时间
     */
    private Date create;
    /**
     * 核销时间
     */
    private Date verifyTime;
    /**
     * 订单状态：0:待支付 1:已支付 2:已完成 3:已退款
     */
    private Integer orderStatus;

}
