package cn.com.duiba.oto.dto.oto.goods.order;

import java.io.Serializable;

/**
 * 支付实体类
 *
 * @author songp
 * @date 2024/8/16 4:56 PM
 */
public class PayDto implements Serializable {

    private static final long serialVersionUID = -7034433110595864690L;


    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;

    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 公众号id
     */
    private String appId;

    /**
     * 签名类型需要和下单一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public Long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }
}
