package cn.com.duiba.oto.oto.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.goods.GoodsDetail;
import cn.com.duiba.oto.dto.oto.goods.GoodsDto;
import cn.com.duiba.oto.dto.oto.goods.WebGoodsDetail;
import cn.com.duiba.oto.param.oto.goods.RemoteGoodsTurnParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSaveOrUpdateGoodsParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSearchGoodsParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSearchParam;
import cn.com.duiba.oto.util.PageResult;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @Author huliangsheng
 * @Date 2024/8/12 17:33
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 商品列表
     */
    PageResult<GoodsDto> list(RemoteSearchGoodsParam param);

    /**
     * 新增商品
     */
    DubboResult<Boolean> save(RemoteSaveOrUpdateGoodsParam param);

    /**
     * 编辑商品
     */
    DubboResult<Boolean> update(RemoteSaveOrUpdateGoodsParam param);

    /**
     * 上架/下架
     */
    DubboResult<Boolean> updateSaleStatus(RemoteGoodsTurnParam param);

    /**
     * 商品详情
     */
    DubboResult<GoodsDetail> detail(Long id);

    /**
     * 商品详情(C端）
     */
    DubboResult<WebGoodsDetail> webGoodsDetail(RemoteSearchParam param);

}
