package cn.com.duiba.oto.dto.oto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author huliangsheng
 * @Date 2024/8/12 16:52
 */
@Data
public class GoodsDto implements Serializable {

    private static final long serialVersionUID = 1220085817764510885L;
    /**
     * 商品id
     */
    private Long id;
    /**
     * 商品标题
     */
    private String goodsTitle;
    /**
     * 商品图片
     */
    private String imageUrl;
    /**
     * 商品有效期
     */
    private Date validPeriod;
    /**
     * 原价
     */
    private Integer originalPrice;
    /**
     * 优惠价
     */
    private Integer favourPrice;
    /**
     * 剩余库存数
     */
    private Integer remainStocks;
    /**
     * 上架时间
     */
    private Date saleTime;
    /**
     * 商品上架状态
     * -1:下架 0:未上架 1:待上架 2:上架中
     */
    private Integer saleStatus;
}
