package cn.com.duiba.oto.enums.pay;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务方类型
 *
 * @author xiaotian
 * @date 2020/2/28 11:51 AM
 */
@Getter
@AllArgsConstructor
public enum BizTypeEnum {

    /**
     * OTO
     */
    OTO(1, "OTO"),
    //VIP礼包
    OTO_VIP_GIFT(2, "OTO_VIP_GIFT"),
    //商品商城
    OTO_MALL(3, "OTO_MALL");


    private static final Map<Integer, BizTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (BizTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    private final Integer code;
    private final String desc;

    public static BizTypeEnum getBizTypeEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
