package cn.com.duiba.oto.dto.oto.amount;

import cn.com.duiba.oto.dto.oto.amount.enums.SourceFromEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户立减金记录new
 *
 * @author songp
 * @date 2024/8/14 3:43 PM
 */
public class ExpireAmountRecordNewDto implements Serializable {
    private static final long serialVersionUID = 16540625622786853L;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 初始立减金(单位分)
     */
    private Long initAmount;

    /**
     * 来源(1、观看视频获取 2、签到获取)
     * @see SourceFromEnum#getType()
     */
    private String amountSource;

    /**
     * 过期时间
     */
    private Date expireTime;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getInitAmount() {
        return initAmount;
    }

    public void setInitAmount(Long initAmount) {
        this.initAmount = initAmount;
    }

    public String getAmountSource() {
        return amountSource;
    }

    public void setAmountSource(String amountSource) {
        this.amountSource = amountSource;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }
}
