package cn.com.duiba.oto.dto.oto.sign;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户签到任务表
 *
 * @TableName tb_oto_sign_task
 */
@Data
public class SignTaskDto implements Serializable {
    private static final long serialVersionUID = -7036990808830898483L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_oto_wx_users.id
     */
    private Long userId;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 任务开始时间
     */
    private Date startTime;

    /**
     * 任务签到天数
     */
    private Integer taskDay;

    /**
     * 实际签到天数
     */
    private Integer signDay;

    /**
     * 任务状态 0:未完成 1:已完成
     */
    private Integer taskStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}