package cn.com.duiba.oto.enums.rights;

import java.util.stream.Stream;

/**
 * 功能描述：权益类型
 *
 * @Auther: xiaotian
 * @Date: 2023/11/20 17:55
 * @Description:
 */
public enum RightTypeEnum {

    DISCOUNT(1, "折扣"),
    TIMES(2, "次数"),
    DURATION(3, "期限");

    private Integer type;

    private String desc;

    RightTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static RightTypeEnum getByType(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(RightTypeEnum.values()).filter(rightTypeEnum -> rightTypeEnum.getType().equals(code)).findFirst().orElse(null);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
