package cn.com.duiba.oto.oto.service.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.account.LaunchAccountDto;
import cn.com.duiba.oto.param.oto.account.LaunchAccountPageParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-16 13:46
 */
@AdvancedFeignClient
public interface RemoteLaunchAccountApiService {

    /**
     * 分页查询
     * @param param 分页参数
     * @return 分页参数
     */
    PageResult<LaunchAccountDto> searchPage(LaunchAccountPageParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 投放账户
     */
    LaunchAccountDto selectById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 投放账户信息
     */
    List<LaunchAccountDto> selectByIds(List<Long> ids);

    /**
     * 新增
     * @param dto 投放账户参数
     * @return 新增结果
     */
    LaunchAccountDto insert(LaunchAccountDto dto);

    /**
     * 修改
     * @param dto 投放账户参数
     * @return 新增结果
     */
    boolean update(LaunchAccountDto dto);

    /**
     * 根据账户名称查询账户
     * @param accountName 账户名称
     * @return 投放账户
     */
    LaunchAccountDto findByAccountName(String accountName);

    /**
     * 根据账户名称模糊查询账户信息
     * @param accountName 模糊账户名称
     * @return 账户集合信息
     */
    List<LaunchAccountDto> fuzzyFindByAccountName(String accountName);

    /**
     * 根据账户id查询账户
     * @param accountId 账户id
     * @return 投放账户
     */
    LaunchAccountDto findByAccountId(String accountId);

    /**
     * 根据账户id查询账户
     * @param accountIds 账户id
     * @return 投放账户
     */
    List<LaunchAccountDto> listByAccountIds(List<String> accountIds);

    /**
     * 根据账户id修改accessToken
     * @param accountId 账户id
     * @param accessToken 三方token
     * @return accessToken
     */
    boolean updateAccessToken(String accountId, String accessToken);
}
