package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.apply.ActivityApplyDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ApplyActivityConfigDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ApplyActivityPrizeConfigDto;

import java.util.List;

/**
 * 功能描述：申请活动相关
 *
 * @Auther: xiaotian
 * @Date: 2024/8/14 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteApplyActivityService {

    /**
     * 获取配置的活动列表
     *
     * @return
     */
    List<ApplyActivityConfigDto> activityList();

    /**
     * 获取配置的奖品列表
     *
     * @return
     */
    List<ApplyActivityPrizeConfigDto> prizeList();

    /**
     * 客户的参与记录
     *
     * @param userId
     * @return
     */
    List<ActivityApplyDto> applyList(Long userId);

    /**
     * 新增参与记录
     *
     * @param activityApplyDto
     * @return
     */
    int insert(ActivityApplyDto activityApplyDto);
}
