package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.jl.CompleteDto;
import cn.com.duiba.oto.param.oto.activity.jl.RemoteCompleteParam;
import cn.com.duiba.oto.param.oto.activity.jl.RemoteJoinParam;
import cn.com.duiba.oto.param.oto.serviceCard.SendMsgParam;

/**
 * 功能描述：巨量社区高客自建落地页
 *
 * @Auther: xiaotian
 * @Date: 2024/05/31 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteJuLiangActivityService {

    /**
     * 检测手机号是否已经预约过
     */
    Boolean checkPhone(SendMsgParam param);

    /**
     * 发送验证码
     */
    Boolean sendMsg(SendMsgParam param) throws BizException;

    /**
     * 提交预约
     */
    Long join(RemoteJoinParam param) throws BizException;

    /**
     * 完善预约信息
     *
     * @return 奖品id
     */
    Boolean complete(RemoteCompleteParam param);

    /**
     * 获取预约信息
     */
    CompleteDto appointmentInfo(Long custId);
}
