package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.OtoSellerConfDto;

import java.util.List;

/**
 * OTO-成员配置信息
 *
 * @author xiaotian
 * @date 2022/9/19 5:59 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerConfService {

    /**
     * 根据销售id获取销售配置信息
     *
     * @param sellerId
     * @return
     */
    List<OtoSellerConfDto> selectBySellerIds(List<Long> sellerId);

    /**
     * 新增更新销售配置信息
     *
     * @param otoSellerConfDto
     * @return
     */
    boolean saveBySellerId(OtoSellerConfDto otoSellerConfDto) throws BizException;
}
