package cn.com.duiba.oto.oto.service.api.remoteservice.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.sign.SignRecordDto;
import cn.com.duiba.oto.dto.oto.sign.SignSubmitDto;
import cn.com.duiba.oto.dto.oto.sign.SignTaskDetailDto;
import cn.com.duiba.oto.param.oto.sign.SignRecordParam;

import java.util.List;

/**
 * @author xiaotian
 * @date 2024/8/19 14:07
 */
@AdvancedFeignClient
public interface RemoteOtoSignService {

    /**
     * 签到
     *
     * @param userId
     * @return
     */
    SignSubmitDto sign(Long userId);

    /**
     * 获取用户签到任务详情
     *
     * @return
     */
    SignTaskDetailDto userSignTask(Long userId);

    /**
     * 获取用户签到记录
     *
     * @param signRecordParam
     * @return
     */
    List<SignRecordDto> userSignRecord(SignRecordParam signRecordParam);

}
