package cn.com.duiba.oto.param.oto.deal;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @date 2024/7/19 13:40
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteSearchDealParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -2110380631058919581L;

    /**
     * 输入搜索：输入投保人姓名、投保人id、被保人姓名搜索具体保单，支持模糊搜索；
     */
    private String searchParam;

    /**
     * 保单号
     */
    private String dealNo;

    /**
     * 保险公司
     */
    private List<String> insurerCompanyList;

    /**
     * 保单状态
     */
    private List<Integer> dealStatusList;

    /**
     * 产品名称
     */
    private List<String> productNameList;

    /**
     * 承保时间（开始）
     */
    private Date coverTimeStart;

    /**
     * 承保时间（结束）
     */
    private Date coverTimeEnd;

    /**
     * 专家Id
     */
    private List<Long> expertIdList;
}
