package cn.com.duiba.oto.param.oto.pay.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 退款收单回执
 *
 * @author xiaotian
 * @date 2020/2/28 11:34 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseRefundResponse extends BaseResponse {

    private static final long serialVersionUID = -4191338585032542751L;

    /**
     * 退款单号(商户退款单号)
     */
    private String outRefundNo;

    /**
     * 上游调用方的退款单号
     */
    private String bizRefundNo;

    /**
     * 设置错误信息
     *
     * @param chargeResponse 退款收单回执
     * @param errorMsg       错误信息
     * @return 退款收单回执
     */
    public static <T extends BaseRefundResponse> T buildErrorMsg(T chargeResponse, String errorMsg) {
        if (chargeResponse == null || errorMsg == null) {
            return chargeResponse;
        }
        chargeResponse.setErrorMsg(errorMsg);
        return chargeResponse;
    }
}
