/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.bean.wx;

import cn.com.duiba.oto.enums.WxErrorCodeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxBaseResponse
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WxBaseResponse.class);
    private static final long serialVersionUID = -5825595760787692887L;
    @JSONField(name="errcode")
    private Long errCode;
    @JSONField(name="errmsg")
    private String errMsg;

    public Boolean success() {
        return Objects.equals(0L, this.getErrCode()) || Objects.isNull(this.getErrCode());
    }

    public static WxBaseResponse paramNull() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-2L);
        wechatResultBean.setErrMsg("\u53c2\u6570\u4e3a\u7a7a");
        return wechatResultBean;
    }

    public static WxBaseResponse requestNoResponse() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-4L);
        wechatResultBean.setErrMsg("\u8bf7\u6c42\u6ca1\u6709\u56de\u590d");
        return wechatResultBean;
    }

    public static WxBaseResponse paramError() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-5L);
        wechatResultBean.setErrMsg("\u53c2\u6570\u9519\u8bef");
        return wechatResultBean;
    }

    public static <T extends WxBaseResponse> T customParamError(String desc, Class<T> responseClass) {
        try {
            WxBaseResponse result = (WxBaseResponse)responseClass.newInstance();
            result.setErrCode(WxErrorCodeEnum.E_5.getCode());
            result.setErrMsg(desc);
            return (T)result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            WxBaseResponse wxBaseResponse = WxBaseResponse.paramError();
            wxBaseResponse.setErrMsg(desc);
            return (T)((WxBaseResponse)BeanUtils.copy((Object)wxBaseResponse, responseClass));
        }
    }

    public static WxBaseResponse requestError() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-7L);
        wechatResultBean.setErrMsg("\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef");
        return wechatResultBean;
    }

    public static WxBaseResponse httpError() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-8L);
        wechatResultBean.setErrMsg("httpclient\u53d1\u751f\u9519\u8bef");
        return wechatResultBean;
    }

    public static WxBaseResponse responseError() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-9L);
        wechatResultBean.setErrMsg("\u8bf7\u6c42\u8fd4\u56de\u503c\u8bfb\u53d6\u9519\u8bef");
        return wechatResultBean;
    }

    public static WxBaseResponse systemError() {
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-9999L);
        wechatResultBean.setErrMsg("\u672a\u77e5\u9519\u8bef");
        return wechatResultBean;
    }

    public Long getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrCode(Long errCode) {
        this.errCode = errCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxBaseResponse)) {
            return false;
        }
        WxBaseResponse other = (WxBaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$errCode = this.getErrCode();
        Long other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        return !(this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxBaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        return result;
    }

    public String toString() {
        return "WxBaseResponse(errCode=" + this.getErrCode() + ", errMsg=" + this.getErrMsg() + ")";
    }
}

