package cn.com.duiba.oto.dto.oto.goods.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/15 14:48
 */
@Data
public class OrderListVO implements Serializable {

    private static final long serialVersionUID = 1220085817764510885L;
    /**
     * 订单id
     */
    private Long id;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 商品图片
     */
    private String goodsImage;

    /**
     * 商品规格
     */
    private String goodsStandard;

    /**
     * 订单商品数量
     */
    private Integer orderStocks;

    /**
     * 订单金额
     */
    private Integer orderPrice;

    /**
     * 订单实付价格
     */
    private Integer paymentPrice;

    /**
     * 用户姓名
     */
    private String custName;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 下单时间
     */
    private Date create;

    /**
     * 订单状态：1:已支付 2:已完成 3:已退款
     */
    private Integer orderStatus;

    /**
     * 预约领取时间
     */
    private Date appointmentTime;

    /**
     * 实际库存
     */
    private Integer actualStocks;

    /**
     * 核销时间
     */
    private Date verifyTime;

    /**
     * 领取方式
     * 1：客户自提 2：销售待领
     */
    private Integer receiveType;
}
