package cn.com.duiba.oto.oto.service.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustInvitationDto;
import cn.com.duiba.oto.dto.oto.cust.OtoCustInvitationRecordDto;
import cn.com.duiba.oto.param.oto.cust.OtoCustInvitationSearchParam;

import java.util.Date;
import java.util.List;

/**
 * @author liuyj
 * @date 2022/8/4 09:38
 */
@AdvancedFeignClient
public interface RemoteCustInvitationService {
    /**
     * 根据客户ID和销售ID查询邀约详情
     * @param param 查询参数
     */
    List<OtoCustInvitationDto> getDetailByCustIdAndSid(OtoCustInvitationSearchParam param);

    /**
     * 根据客户id获取邀约基础信息
     *
     * @param custId 客户id
     * @return 邀约基础信息
     */
    OtoCustInvitationDto findByCustId(Long custId);

    /**
     * 根据客户ID查询邀约信息
     *
     * @param finalCustIds 客户ID
     */
    List<OtoCustInvitationDto> getAllByCustIds(List<Long> finalCustIds);

    /**
     * 新增邀约基础信息
     *
     * @param param 参数
     * @return 结果
     */
    boolean save(OtoCustInvitationSearchParam param);

    /**
     * 编辑邀约基础信息
     * 注意：客户A的见面场景改了、（需要就餐改成否、需要接送改成否，接送地址清空）
     * @param param 参数
     * @return 结果
     */
    boolean update(OtoCustInvitationSearchParam param);

    /**
     * 根据销售ID和承诺时间查询邀约基础信息
     * @param param 查询参数
     */
    List<OtoCustInvitationDto> getAllByCustSidAndInvitationTime(OtoCustInvitationSearchParam param);

    /**
     * 根据面访行程状态和承诺时间查询邀约基础信息
     * @param param 查询参数
     */
    List<OtoCustInvitationDto> getAllByInvitationStatusAndInvitationTime(OtoCustInvitationSearchParam param);

    /**
     * 根据约见时间查询邀约信息
     * @param interviewBeginTime
     * @param interviewEndTime
     */
    List<OtoCustInvitationDto> getAllByInterviewTime(Date interviewBeginTime, Date interviewEndTime, Integer firstInterviewFlag);


    /**
     * 退回邀约组，发送企微和公众号消息
     * @param oldInvitation
     * @param recordDto
     */
    void assignRollbackSendQwMessage(OtoCustInvitationDto oldInvitation, OtoCustInvitationRecordDto recordDto);

    /**
     * 根据客户ID删除邀约
     * @param customerId 客户ID
     */
    boolean deleteByCustomerId(Long customerId);

}
