/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.util;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.oto.enums.push.PushMessageTypeEnum;
import cn.com.duiba.wolf.utils.UrlUtils2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PushEmbedUtils {
    private static final String SEPARATOR = "_";

    private PushEmbedUtils() {
    }

    public static String getPushParamStr(Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return (oaId == null ? "" : IdMakeUtil.encodingId((Long)oaId)) + SEPARATOR + (StringUtils.isBlank((String)eventType) ? "" : eventType) + SEPARATOR + (messageTypeEnum == null ? "" : messageTypeEnum.getType()) + SEPARATOR + (urlOrder == null ? "" : urlOrder) + SEPARATOR + (dpm == null ? "" : dpm);
    }

    public static String getPushParamStrShort(Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return (oaId == null ? "" : Long.valueOf(oaId + 3L)) + SEPARATOR + (eventType == null ? "" : eventType) + SEPARATOR + (messageTypeEnum == null ? "" : messageTypeEnum.getType()) + SEPARATOR + (urlOrder == null ? "" : urlOrder) + SEPARATOR + (dpm == null ? "" : dpm);
    }

    public static Map<String, String> getPushParamMapByStr(String pushParamStr) {
        if (StringUtils.isBlank((String)pushParamStr)) {
            return Collections.emptyMap();
        }
        Long oaId = null;
        String pushId = null;
        Integer messageType = null;
        Integer urlOrder = null;
        String dpm = null;
        String[] split = pushParamStr.split(SEPARATOR);
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            if (StringUtils.isBlank((String)str)) continue;
            if (i == 0) {
                oaId = NumberUtils.isNumber((String)str) ? Long.valueOf(Long.parseLong(str) - 3L) : IdMakeUtil.decodingId((String)str);
            }
            if (i == 1) {
                pushId = str;
            }
            if (i == 2 && NumberUtils.isNumber((String)str)) {
                messageType = Integer.parseInt(str);
            }
            if (i == 3 && NumberUtils.isNumber((String)str)) {
                urlOrder = Integer.parseInt(str);
            }
            if (i != 4) continue;
            dpm = str;
        }
        return PushEmbedUtils.getPushParamMap(oaId, pushId, messageType, urlOrder, dpm, null);
    }

    public static String getPushParam(Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(oaId, eventType, messageTypeEnum, urlOrder, dpm, null);
        return UrlUtils2.buildUrlParams(pushParamMap);
    }

    public static String getPushParam(Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils2.buildUrlParams(pushParamMap);
    }

    public static String getEncodePushParam(Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return PushEmbedUtils.encode(PushEmbedUtils.getPushParam(oaId, eventType, messageTypeEnum, urlOrder, dpm));
    }

    public static String buildPushParam(String url, Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return PushEmbedUtils.buildPushParam(url, oaId, eventType, messageTypeEnum, urlOrder, dpm, null);
    }

    public static String buildPushParam(String url, Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm, String markValue) {
        Map<String, String> params = PushEmbedUtils.getPushParamMap(oaId, eventType, messageTypeEnum, urlOrder, dpm, markValue);
        if (!url.contains("?")) {
            return UrlUtils2.appendParams((String)url, params);
        }
        Map map = UrlUtils2.extractUrlParamsFromUrl((String)url);
        if (MapUtils.isEmpty((Map)map)) {
            return UrlUtils2.appendParams((String)url, params);
        }
        String uriUrl = (String)map.get("uri");
        if (StringUtils.isBlank((String)uriUrl)) {
            return UrlUtils2.appendParams((String)url, params);
        }
        String decode = PushEmbedUtils.decode(uriUrl);
        String decodePushUrl = UrlUtils2.appendParams((String)decode, params);
        map.put("uri", PushEmbedUtils.encode(decodePushUrl));
        return UrlUtils2.appendParams((String)UrlUtils2.extractUrl((String)url), (Map)map);
    }

    public static String buildMpPushParam(String page, String markValue) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (markValue == null) {
            markValue = "";
        }
        params.put("unique_mark", markValue);
        return UrlUtils2.appendParams((String)page, params);
    }

    public static String buildPushParam(String url, Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils2.appendParams((String)url, pushParamMap);
    }

    public static Map<String, String> getPushParamMap(Map<String, String[]> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        Set<String> pushKey = PushEmbedUtils.getPushParamMap((Long)0L, "", 0, (Integer)0, null, "").keySet();
        for (String key : pushKey) {
            String[] param = parameterMap.get(key);
            if (!PushEmbedUtils.isNotEmpty(param)) continue;
            params.put(key, param[0]);
        }
        return params;
    }

    public static String getDpmByPushEventEnum(String eventEnum) {
        if (eventEnum == null) {
            return "";
        }
        if (Objects.equals(eventEnum, "D3")) {
            return "11.9.0.0";
        }
        if (Objects.equals(eventEnum, "D4")) {
            return "11.10.0.0";
        }
        if (Objects.equals(eventEnum, "S1")) {
            return "11.12.0.0";
        }
        if (Objects.equals(eventEnum, "S5")) {
            return "11.14.0.0";
        }
        if (Objects.equals(eventEnum, "S6")) {
            return "11.15.0.0";
        }
        if (Objects.equals(eventEnum, "S7")) {
            return "11.16.0.0";
        }
        if (Objects.equals(eventEnum, "S8")) {
            return "11.17.0.0";
        }
        if (Objects.equals(eventEnum, "S9")) {
            return "11.18.0.0";
        }
        if (Objects.equals(eventEnum, "S10")) {
            return "11.19.0.0";
        }
        if (Objects.equals(eventEnum, "S11")) {
            return "11.20.0.0";
        }
        if (Objects.equals(eventEnum, "V1")) {
            return "11.22.0.0";
        }
        if (Objects.equals(eventEnum, "V2")) {
            return "11.23.0.0";
        }
        if (Objects.equals(eventEnum, "V4")) {
            return "11.24.0.0";
        }
        if (Objects.equals(eventEnum, "S12")) {
            return "11.25.0.0";
        }
        if (Objects.equals(eventEnum, "S13")) {
            return "11.26.0.0";
        }
        if (Objects.equals(eventEnum, "S14")) {
            return "11.27.0.0";
        }
        if (Objects.equals(eventEnum, "S15")) {
            return "11.28.0.0";
        }
        if (Objects.equals(eventEnum, "S17")) {
            return "11.30.0.0";
        }
        if (Objects.equals(eventEnum, "S18")) {
            return "11.31.0.0";
        }
        if (Objects.equals(eventEnum, "S19")) {
            return "11.32.0.0";
        }
        if (Objects.equals(eventEnum, "S4")) {
            return "11.34.0.0";
        }
        if (Objects.equals(eventEnum, "S27")) {
            return "11.37.0.0";
        }
        return PushEmbedUtils.calculateDpm(eventEnum);
    }

    private static Map<String, String> getPushParamMap(Long oaId, String eventType, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm, String markValue) {
        String pushId = StringUtils.isBlank((String)eventType) ? null : eventType;
        Integer messageType = Objects.isNull((Object)messageTypeEnum) ? null : messageTypeEnum.getType();
        return PushEmbedUtils.getPushParamMap(oaId, pushId, messageType, urlOrder, dpm, markValue);
    }

    private static Map<String, String> getPushParamMap(Long oaId, String pushId, Integer messageType, Integer urlOrder, String dpm, String markValue) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("push", "push");
        if (Objects.nonNull(oaId)) {
            params.put("oa_id", IdMakeUtil.encodingId((Long)oaId));
        }
        if (Objects.nonNull(pushId)) {
            params.put("push_id", pushId);
        }
        if (Objects.nonNull(messageType)) {
            params.put("message_type", String.valueOf(messageType));
        }
        if (Objects.nonNull(urlOrder)) {
            params.put("url_order", String.valueOf(urlOrder));
        }
        params.put("access_source", PushEmbedUtils.getAccessSourceByPushId(pushId));
        if (StringUtils.isNotBlank((String)dpm)) {
            params.put("dpm", dpm);
        }
        if (markValue != null) {
            params.put("unique_mark", markValue);
        }
        return params;
    }

    private static String getAccessSourceByPushId(String pushId) {
        if (StringUtils.isBlank((String)pushId) || pushId.length() < 2) {
            return "1";
        }
        String numByPushId = PushEmbedUtils.getNumByPushId(pushId);
        if (StringUtils.isBlank((String)numByPushId)) {
            return "1";
        }
        String accessSource = "10";
        accessSource = accessSource + numByPushId;
        String num = pushId.substring(1);
        while (num.length() < 3) {
            num = "0" + num;
        }
        return accessSource + num;
    }

    private static String getNumByPushId(String pushId) {
        String word;
        if (StringUtils.isBlank((String)pushId) || pushId.length() < 1) {
            return "";
        }
        switch (word = pushId.substring(0, 1)) {
            case "S": {
                return "1";
            }
            case "D": {
                return "2";
            }
            case "H": {
                return "3";
            }
            case "V": {
                return "4";
            }
            case "X": {
                return "5";
            }
            case "Z": {
                return "6";
            }
            case "L": {
                return "7";
            }
        }
        return "";
    }

    private static String calculateDpm(String eventType) {
        if (StringUtils.isBlank((String)eventType)) {
            return "";
        }
        if (eventType.length() < 2) {
            return "";
        }
        String numByPushId = PushEmbedUtils.getNumByPushId(eventType);
        if (StringUtils.isBlank((String)numByPushId)) {
            return "";
        }
        return "11.0." + numByPushId + "." + eventType.substring(1);
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static boolean isNotEmpty(String[] param) {
        return Objects.nonNull(param) && param.length > 0;
    }

    public static String insertUniqueMark(String msg, String eventType, String markValue) {
        int eventTypeIndex;
        int pushIdIndex;
        if (StringUtils.isBlank((String)msg) || eventType == null) {
            return msg;
        }
        String pushIdKey = "push_id";
        StringBuilder sb = new StringBuilder();
        int pushIdKeyLength = pushIdKey.length();
        int eventTypeLength = eventType.length();
        int lastIndex = 0;
        while (lastIndex < msg.length() && (pushIdIndex = msg.indexOf(pushIdKey, lastIndex)) >= 0 && (eventTypeIndex = msg.indexOf(eventType, pushIdIndex)) >= 0) {
            int pushIdLastIndex = pushIdIndex + pushIdKeyLength;
            int eventTypeLastIndex = eventTypeIndex + eventTypeLength;
            String equalSign = msg.substring(pushIdLastIndex, eventTypeIndex);
            int count = PushEmbedUtils.encodeCount(equalSign);
            String mark = PushEmbedUtils.getMark(count, markValue);
            sb.append(msg, lastIndex, pushIdIndex);
            sb.append(mark);
            sb.append(msg, pushIdIndex, eventTypeLastIndex);
            lastIndex = eventTypeLastIndex;
        }
        sb.append(msg.substring(lastIndex));
        return sb.toString();
    }

    private static String getMark(int encodeCount, String markValue) {
        String mark = "unique_mark=" + markValue + "&";
        if (encodeCount <= 0) {
            return mark;
        }
        for (int i = 0; i < encodeCount; ++i) {
            mark = PushEmbedUtils.encode(mark);
        }
        return mark;
    }

    private static int encodeCount(String equalSign) {
        int encodeCount = 0;
        if (StringUtils.isBlank((String)equalSign)) {
            return encodeCount;
        }
        String sign = "=";
        int maxCount = 5;
        for (int i = 0; i < maxCount; ++i) {
            if (StringUtils.equals((String)equalSign, (String)sign)) {
                return encodeCount;
            }
            equalSign = PushEmbedUtils.decode(equalSign);
            ++encodeCount;
        }
        return encodeCount;
    }
}

