package cn.com.duiba.oto.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 对象与map互相转换的时候，用于设置字段的map的key值
 *
 * @author xiaotian
 * @date 2020/2/27 3:48 PM
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.FIELD})
public @interface FieldMapKey {

    String value() default "";

    /**
     * true 忽略-不需要转换
     */
    boolean ignore() default false;
}
