package cn.com.duiba.oto.oto.service.api.remoteservice.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.sign.SignTaskConfigBean;
import cn.com.duiba.oto.dto.oto.sign.SignRecordDto;
import cn.com.duiba.oto.dto.oto.sign.SignSubmitDto;
import cn.com.duiba.oto.dto.oto.sign.SignTaskBackDto;
import cn.com.duiba.oto.dto.oto.sign.SignTaskDetailDto;
import cn.com.duiba.oto.dto.oto.sign.SignTaskDto;
import cn.com.duiba.oto.param.oto.sign.SignRecordParam;
import cn.com.duiba.oto.param.oto.sign.SignRecordQueryParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * @author xiaotian
 * @date 2024/8/19 14:07
 */
@AdvancedFeignClient
public interface RemoteOtoSignService {

    /**
     * 签到
     *
     * @param userId
     * @return
     */
    SignSubmitDto sign(Long userId);

    /**
     * 获取用户签到任务详情
     *
     * @return
     */
    SignTaskDetailDto userSignTask(Long userId);

    /**
     * 获取用户签到记录
     *
     * @param signRecordParam
     * @return
     */
    List<SignRecordDto> userSignRecord(SignRecordParam signRecordParam);

    /**
     * 查询用户已完成的签到任务
     *
     * @param userId
     * @return
     */
    List<SignTaskDto> getAllFinishTask(Long userId);

    /**
     * 查询签到任务列表（管理后台）
     *
     * @param param 参数
     * @return 分页数据
     */
    PageResult<SignTaskBackDto> querySignTaskList(SignRecordQueryParam param);

    /**
     * 批量核销签到任务奖励
     *
     * @param taskIds
     * @return
     */
    boolean verfitySign(List<Long> taskIds);

    /**
     * 获取所有的签到奖励任务配置
     *
     * @return
     */
    List<SignTaskConfigBean> allTaskConfig();

    /**
     * 获取用户的所有的签到任务
     *
     * @param userId
     * @return
     */
    List<SignTaskDto> userTasks(List<Long> userId);

}
