/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.follow;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum OtoCustAssignTypeEnum {
    ADMIN_ASSIGN(1, "\u7ba1\u7406\u540e\u53f0\u5206\u914d"),
    SELLER_TAKE_FRESH(2, "\u9500\u552e\u4e3b\u52a8\u4ece\u6295\u653e\u6c60\u8ba4\u9886"),
    SELLER_TAKE_RECYCLE(3, "\u9500\u552e\u4e3b\u52a8\u4ece\u56de\u6536\u6c60\u8ba4\u9886"),
    SYSTEM_ASSIGN(4, "\u7cfb\u7edf\u5f3a\u5236\u5206\u914d"),
    SELF_BUILT(5, "\u81ea\u5efa\u5ba2\u6237"),
    INVITE_TO_TAKE(6, "\u9080\u7ea6\u5206\u914d\u5e26\u770b"),
    ASSIGN_TO_ROLLBACK(7, "\u9000\u56de\u9080\u7ea6\u7ec4"),
    ADMIN_BATCH_ASSIGN(8, "\u7ba1\u7406\u5458\u6279\u91cf\u5206\u914d"),
    LIVE_ASSIGN(9, "\u76f4\u64ad\u9080\u7ea6\u5206\u914d"),
    RECYCLE_TO_LEADER_ASSIGN(10, "\u56de\u6536\u5ba2\u6237\u7ec4\u5efa\u95f4\u6d41\u8f6c\u5206\u914d"),
    SEPARETE_ASSIGN(11, "\u7cfb\u7edf\u8131\u843d\u5206\u914d");

    private final Integer assignType;
    private final String desc;
    private static final List<OtoCustAssignTypeEnum> FORCE_ASSIGN_LIST;
    private static final List<OtoCustAssignTypeEnum> NEED_NOT_ADD_COEFFICIENT;

    public static final List<Integer> forceAssignTypes() {
        return FORCE_ASSIGN_LIST.stream().map(OtoCustAssignTypeEnum::getAssignType).collect(Collectors.toList());
    }

    public static final boolean needNotAddCoefficient(Integer otoCustAssignType) {
        return NEED_NOT_ADD_COEFFICIENT.stream().anyMatch(otoCustAssignTypeEnum -> otoCustAssignTypeEnum.getAssignType().equals(otoCustAssignType));
    }

    public Integer getAssignType() {
        return this.assignType;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustAssignTypeEnum(Integer assignType, String desc) {
        this.assignType = assignType;
        this.desc = desc;
    }

    static {
        FORCE_ASSIGN_LIST = Lists.newArrayList();
        NEED_NOT_ADD_COEFFICIENT = Arrays.asList(ASSIGN_TO_ROLLBACK);
        FORCE_ASSIGN_LIST.add(ADMIN_ASSIGN);
        FORCE_ASSIGN_LIST.add(SYSTEM_ASSIGN);
        FORCE_ASSIGN_LIST.add(ADMIN_BATCH_ASSIGN);
    }
}

