package cn.com.duiba.oto.oto.service.api.remoteservice.goods.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.CustBuyPreferentialBean;
import cn.com.duiba.oto.dto.oto.goods.order.ApplyRefundParam;
import cn.com.duiba.oto.dto.oto.goods.order.OrderCountDto;
import cn.com.duiba.oto.dto.oto.goods.order.OrderDetail;
import cn.com.duiba.oto.dto.oto.goods.order.OrderLastAppointmentTimeDto;
import cn.com.duiba.oto.dto.oto.goods.order.OrderListVO;
import cn.com.duiba.oto.dto.oto.goods.order.PayDto;
import cn.com.duiba.oto.dto.oto.goods.order.RefundGoodOrderParam;
import cn.com.duiba.oto.param.oto.goods.RemoteGenerateOrderParam;
import cn.com.duiba.oto.param.oto.goods.RemoteMngAddOrderParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteAppiontmentTimeParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteExtendPreferentialParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteSearchOrderParam;
import cn.com.duiba.oto.util.PageResult;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * @Description 订单接口
 * @Author huliangsheng
 * @Date 2024/8/14 15:45
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 订单列表
     */
    @Deprecated
    DubboResult<PageResult<OrderListVO>> list(RemoteSearchOrderParam param);

    /**
     * 订单列表
     */
    PageResult<OrderListVO> orderList(RemoteSearchOrderParam param) throws BizException;

    /**
     * 订单详情
     */
    @Deprecated
    DubboResult<OrderDetail> detail(Long id);

    /**
     * 订单详情
     */
    OrderDetail orderDetail(Long id) throws BizException;

    /**
     * 核销
     * 核销时间，默认当前时间
     */
    Boolean verify(Long id);

    /**
     * 核销
     */
    Boolean verify4Time(Long id, Date time);

    /**
     * 退款
     */
    @Deprecated
    DubboResult<Boolean> refund(RefundGoodOrderParam param);

    /**
     * 退款
     */
    Boolean orderRefund(RefundGoodOrderParam param) throws BizException;

    /**
     * 订单申请退款(C端退款)
     */
    @Deprecated
    DubboResult<Boolean> applyRefund(ApplyRefundParam param);

    /**
     * 订单申请退款(C端退款)
     */
    Boolean applyOrderRefund(ApplyRefundParam param) throws BizException;

    /**
     * 生成商品订单
     */
    @Deprecated
    DubboResult<PayDto> orderGoods(RemoteGenerateOrderParam param);

    /**
     * 生成商品订单
     */
    PayDto orderGoods4Web(RemoteGenerateOrderParam param) throws BizException;

    /**
     * 管理后台手动新增订单
     *
     * @param remoteMngAddOrderParam
     * @return
     */
    Boolean mngAddOrder(RemoteMngAddOrderParam remoteMngAddOrderParam) throws BizException;

    /**
     * 批量修改预约领取时间
     */
    int updateAppointmentTime(RemoteAppiontmentTimeParam param);

    /**
     * 修改领取方式
     *
     * @param id
     * @param receiveType
     * @see cn.com.duiba.oto.enums.goods.order.OrderReceiveTypeEnum
     */
    int updateReceiveType(Long id, Integer receiveType);

    /**
     * 修改核销时间（管理后台）
     */
    int updateVerifyTime(Long id, Date verifyTime);

    /**
     * 查询用户订单统计
     *
     * @param userId
     * @return
     */
    List<OrderCountDto> countUserByOrderStatus(Long userId);

    /**
     * 查询未领取订单数量
     * 订单状态为已支付
     *
     * @param userIds
     * @return
     */
    List<OrderCountDto> countUserNotReceive(List<Long> userIds);

    /**
     * 查询可领取订单数量
     * 订单状态为已支付，并且商品有实际库存
     *
     * @param userIds
     * @return
     */
    List<OrderCountDto> countUserCanReceive(List<Long> userIds);


    /**
     * 查询用户最近一次预约时间
     *
     * @param userIds
     * @return
     */
    List<OrderLastAppointmentTimeDto> userLastAppointmentTime(List<Long> userIds);

    /**
     * 是否在优惠时间内
     *
     * @param userId
     * @return
     */
    CustBuyPreferentialBean inPreferential(Long custId, Long userId);

    /**
     * (延长/取消)优惠时间
     *
     * @param param
     * @return
     */
    Boolean extendPreferential(RemoteExtendPreferentialParam param) throws BizException;
}
