package cn.com.duiba.oto.dto.oto.interview;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liuyj
 * @date 2022/8/31 20:05
 */
@Data
public class OtoCustInterviewDto implements Serializable {
    /** 主键id */
    private Long id;

    /** 客户ID */
    private Long customerId;

    /** 销售ID */
    private Long sellerId;

    /** 面访类型 */
    private Integer interviewType;

    /**
     * 面访状态：{@link cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum}
     */
    private Integer interviewStatus;

    /** 是否提交养老计划方案 */
    private Integer commitPlanFlag;

    /** 提交方案后客户状态 */
    private Integer commitCustStatus;

    /** 客户是否已确认投保要素  0:否 1：是 {@link cn.com.duiba.oto.enums.BooleanEnum} */
    private Integer commitInsure;

    /** 提交时间 */
    private Date commitTime;

    /** 面访地址 */
    private String interviewAddress;

    /** 面访地址的经度 */
    private String interviewLongitude;

    /** 面访地址的纬度 */
    private String interviewLatitude;

    /** 客户评价 */
    private String evaluateDetail;

    /** 面访客户扫码类型 */
    private Integer scanCodeType;

    /** 扫码者对应userId tb_users表 id */
    private Long scanUserId;

    /** 面访码ID tb_mp_qrcode表主键 */
    private Long scanCodeId;

    /** 面访备注 */
    private String interviewRemark;

    /** 面访时间 */
    private Date interviewTime;

    /** 预约时间 */
    private Date appointmentTime;

    /** 客户权重 1:A 2:B 3:C */
    private Integer followWeight;

    /** 客户价值 */
    private Integer custValue;

    /** 核心决策人 1："不明或其他" 2:"自己" 3："配偶" 4："子女" 5："父母" */
    private String coreMaker;

    /** 创建时间 */
    private Date gmtCreate;

    /** 更新时间 */
    private Date gmtModified;

    /** 面访异常类型 {@link cn.com.duiba.oto.enums.interview.UnusualTypeEnum} */
    private String unusualType;

    /** 面访异常说明 */
    private String unusualExplain;

    /** 面访异常上传图片凭证 */
    private String unusualProof;

    /**
     * 是否可送计划书 0否 1是
     */
    private Integer giveProspectusFlag;

    /**
     * 计划书金额
     */
    private String prospectusAmount;

    /**
     * 计划书确认情况
     */
    private String prospectusDesc;
    /**
     * 见面场景配置ID
     */
    private Long interviewConfId;
    /**
     * 见面目的
     */
    private Integer custPhase;

}
