package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * OTO-任务配置-客户状态
 *
 * @author Meichang
 */
@Getter
@AllArgsConstructor
public enum OtoSellerTaskTypeEnum {

    NOT_CONNECT(1, "未打通过"),
    REJECT(2, "拒绝客户"),
    TODAY_CONTACT(3, "当日需再次跟进客户"),
    TOMORROW_INVITATION(4, "明日准面访客户行程"),
    DOVE(5, "鸽子客户"),
    BACK(6, "退回客户"),
    ASSIGN(7, "承接客户")

    ;
    private Integer code;

    private String desc;

    public static OtoSellerTaskTypeEnum getByCode(Integer code) {
        for (OtoSellerTaskTypeEnum otoCustConfStatusEnum : OtoSellerTaskTypeEnum.values()) {
            if (otoCustConfStatusEnum.getCode().equals(code)) {
                return otoCustConfStatusEnum;
            }
        }
        return null;
    }
}
