package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户经营看板业务枚举
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardStatisticsSubForInterviewEnum {
    INTERVIEW(1, "面访总数"),
    FRIST(2, "一面"),
    SECOND(3, "二面"),
    MORE(4, "三面及以上"),
    FRIST_SALON(5, "一面沙龙"),
    DEICTOR_SALON(6, "总监运营沙龙"),
    COMMUNITY(7, "参观社区"),
    OTHER(8, "其他")
    ;

    private static final Map<Integer, CustBulletinBoardStatisticsSubForInterviewEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardStatisticsSubForInterviewEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustBulletinBoardStatisticsSubForInterviewEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardStatisticsSubForInterviewEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
