package cn.com.duiba.oto.enums.goods.order;

import lombok.Getter;

import java.util.Arrays;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/15 11:00
 */
@Getter
public enum OrderSourceEnum {

    SELF(1, "客户下单"),
    MNG(2, "后台创建");


    private Integer type;

    private String desc;

    OrderSourceEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static OrderSourceEnum getByType(Integer type) {
        return Arrays.stream(OrderSourceEnum.values()).filter(item -> item.getType().equals(type)).findFirst().orElse(null);
    }
}
