package cn.com.duiba.oto.enums.separate;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @date 2020/5/18 4:21 PM
 */
public enum CheckTypeEnum {

    INTERVIEW(1, "面访"),
    DEAL(2, "成交"),
    CALL(3, "电话"),
    ;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CheckTypeEnum::getCode, CheckTypeEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    CheckTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据类型获取描述
     */
    public static String getDescCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ALL_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
