package cn.com.duiba.oto.enums.wx;

import cn.com.duiba.oto.enums.OtoOaTargetEnum;

import java.util.Objects;

/**
 * @author xiaotian
 */
public enum OtoOATypeEnum {

    /**
     * 主体小程序
     */
    MP(1, OtoOaTargetEnum.MP.getCode(), "主体小程序") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.MP;
        }
    },
    /**
     * 主体公众号
     */
    MAIN_OA(2, OtoOaTargetEnum.OA.getCode(), "主体公众号") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.OA;
        }
    },
    /**
     * 支付小程序
     */
    PAY_MP(3, OtoOaTargetEnum.MP.getCode(), "支付小程序") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.MP;
        }
    },
    /**
     * 团购小程序
     */
    BUY_MP(4, OtoOaTargetEnum.MP.getCode(), "团购小程序") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.MP;
        }
    },

    /**
     * 团购小程序
     */
    PET_MP(5, OtoOaTargetEnum.MP.getCode(), "爱宠小程序") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.MP;
        }
    };


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 1:公众号 2：小程序 3:web应用
     */
    private final Integer target;

    /**
     * 描述
     */
    private final String desc;

    OtoOATypeEnum(Integer type, Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public static OtoOATypeEnum typeOf(Integer type) {
        for (OtoOATypeEnum e : values()) {
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getTarget() {
        return target;
    }

    public abstract OtoUserExtTypeEnum change2ExtTypeEnum();

}
