package cn.com.duiba.oto.param.oto.interview;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @date 2024/02/04 17:13
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteInterviewBoardSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -6649069489976909712L;
    /**
     * 客户入库开始时间
     */
    private Date createStartTime;

    /**
     * 客户入库结束时间
     */
    private Date createEndTime;

    /**
     * 见面开始时间
     */
    private Date interviewStartTime;

    /**
     * 见面结束时间
     */
    private Date interviewEndTime;

    /**
     * 提报开始时间
     */
    private Date submitStartTime;

    /**
     * 提报结束时间
     */
    private Date submitEndTime;

    /**
     * 客户Id/姓名
     */
    private String param;

    /**
     * 见面场景id
     */
    private List<Long> scenceId;

    /**
     * 权限销售id
     */
    private List<Long> authSellerIds;

    /**
     * 搜索的销售id列表
     */
    private List<Long> searchSellerIds;

    /**
     * 客户来源
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private List<String> custFromSourceList;

    /**
     * 面访状态：{@link cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum}
     * 4:已通过 6：待审批 8：已驳回
     */
    private Integer interviewStatus;

    /**
     * 是否标记成单 0否 1是
     */
    private Integer dealFlag;
}
