package cn.com.duiba.oto.oto.service.api.remoteservice.pet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.pet.OtoUserAddressDto;

import java.util.List;

/**
 * 微信地址相关
 *
 * @author xiaotian
 * @date 2024/8/8 2:15 PM
 */
@AdvancedFeignClient
public interface RemoteUserAddressService {

    /**
     * 新增地址
     */
    boolean addAddress(OtoUserAddressDto otoUserAddressDto);

    /**
     * 删除地址
     */
    boolean deleteAddress(Long id);

    /**
     * 修改地址
     */
    boolean updateAddress(OtoUserAddressDto otoUserAddressDto);

    /**
     * 查询地址
     */
    List<OtoUserAddressDto> queryAddress(Long userId);

    /**
     * 标记默认地址
     */
    boolean markDefaultAddress(Long id) throws BizException;
}
