package cn.com.duiba.oto.vo;

import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author liuyj
 * @date 2022/9/14 14:52
 */
@Data
public class WxWorkChatVO<T>  implements Serializable {
    private static final long serialVersionUID = 5033472050991731743L;

    /**
     * 会话ID
     */
    private String chatId;

    /**
     * 页码
     */
    private Integer pageIndex;
    /**
     * 查询条数
     */
    private Integer pageSize;
    /**
     * 数据总量
     */
    private Long totalCount;

    /**
     * 是否还有下一页
     * true-还有下一页
     * false-没有下一页
     */
    private Boolean hasNext;
    /**
     * 数据
     */
    private List<T> list;

    public static <T> WxWorkChatVO<T> init(Integer pageIndex, Integer pageSize) {
        WxWorkChatVO<T> pageResult = new WxWorkChatVO<>();
        pageResult.setList(Lists.newArrayList());
        pageResult.setTotalCount(0L);
        pageResult.setPageIndex(pageIndex);
        pageResult.setPageSize(pageSize);
        return pageResult;
    }

}
