package cn.com.duiba.oto.bean.dingTalk;


import cn.com.duiba.oto.bean.dingTalk.builder.BtnArrayActionCardDtcBuilder;
import cn.com.duiba.oto.bean.dingTalk.builder.BtnSingleActionCardDtcBuilder;
import cn.com.duiba.oto.bean.dingTalk.builder.FeedCardDtcBuilder;
import cn.com.duiba.oto.bean.dingTalk.builder.LinkDtcBuilder;
import cn.com.duiba.oto.bean.dingTalk.builder.MarkdownDtcBuilder;
import cn.com.duiba.oto.bean.dingTalk.builder.TextDtcBuilder;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2024-11-25 10:12
 */
public class DingTalkContentBuilder {

    protected DingTalkContent dingTalkContent = new DingTalkContent();

    /**
     * 创建文本类型消息
     */
    public static TextDtcBuilder createText() {
        final TextDtcBuilder textDtcBuilder = new TextDtcBuilder();
        textDtcBuilder.dingTalkContent.setMsgtype("text");
        return textDtcBuilder;
    }

    /**
     * 创建链接类型消息
     */
    public static LinkDtcBuilder createLink() {
        final LinkDtcBuilder linkDtcBuilder = new LinkDtcBuilder();
        linkDtcBuilder.dingTalkContent.setMsgtype("link");
        return linkDtcBuilder;
    }

    /**
     * 创建markdown类型消息
     */
    public static MarkdownDtcBuilder createMarkdown() {
        final MarkdownDtcBuilder markdownDtcBuilder = new MarkdownDtcBuilder();
        markdownDtcBuilder.dingTalkContent.setMsgtype("markdown");
        return markdownDtcBuilder;
    }

    /**
     * 创建整个卡片跳转类型消息
     */
    public static BtnSingleActionCardDtcBuilder createBtnSingleActionCard() {
        final BtnSingleActionCardDtcBuilder btnSingleActionCardDtcBuilder = new BtnSingleActionCardDtcBuilder();
        btnSingleActionCardDtcBuilder.dingTalkContent.setMsgtype("actionCard");
        return btnSingleActionCardDtcBuilder;
    }

    /**
     * 创建按钮列表卡片跳转类型消息
     */
    public static BtnArrayActionCardDtcBuilder createBtnArrayActionCard() {
        final BtnArrayActionCardDtcBuilder btnArrayActionCardDtcBuilder = new BtnArrayActionCardDtcBuilder();
        btnArrayActionCardDtcBuilder.dingTalkContent.setMsgtype("actionCard");
        return btnArrayActionCardDtcBuilder;
    }

    /**
     * 创建反馈卡片跳转类型消息
     */
    public static FeedCardDtcBuilder createFeedCard() {
        final FeedCardDtcBuilder feedCardDtcBuilder = new FeedCardDtcBuilder();
        feedCardDtcBuilder.dingTalkContent.setMsgtype("feedCard");
        return feedCardDtcBuilder;
    }

    public DingTalkContent build() {
        return dingTalkContent;
    }

    public DingTalkContentBuilder setAtMobiles(List<String> mobiles) {
        this.dingTalkContent.setAtMobiles(mobiles);
        return this;
    }

    public DingTalkContentBuilder setAtUsersIds(List<String> userIds) {
        this.dingTalkContent.setAtUserIds(userIds);
        return this;
    }

    public DingTalkContentBuilder setAtAll(boolean isAtAll) {
        this.dingTalkContent.setAtAll(isAtAll);
        return this;
    }
}
